//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.Controls 1.0

PopupAnchorItem {
    id : flyout

    default property Component content
    property int menuTopMargin : 10

    popup : Rectangle {
        id : menu

        property Item item

        Component.onCompleted : item = flyout.content.createObject(menu)

        width : item ? item.width : 100
        height : item ? item.height : 100
        opacity : 0

        anchors {
            horizontalCenter : parent.horizontalCenter
            top : parent.top
            topMargin : flyout.menuTopMargin
        }

        states : [
            State {
                name : "visible"
                when : flyout.popupVisible

                PropertyChanges {
                    target : menu
                    opacity : 1
                }
            }
        ]

        transitions : Transition {
            NumberAnimation {
                property : "opacity"
                duration : 200
            }
        }
    }
}
